/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2813;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.client.gui.INameableEmptySlot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.ISlotDecorationRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SearchBox;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageGuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeGuiManager;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeSettingsTabControl;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.InventoryScrollPanel;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.TextBox;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageBackgroundProperties;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageInventorySlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.mixin.client.accessor.AbstractContainerScreenAccessor;
import net.p3pp3rf1y.sophisticatedcore.mixin.common.accessor.SlotAccessor;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.TransferFullSlotMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.ICraftingUIPart;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import org.joml.Matrix4f;

public abstract class StorageScreenBase<S extends StorageContainerMenuBase<?>>
extends class_465<S>
implements InventoryScrollPanel.IInventoryScreen {
    public static final int ERROR_BACKGROUND_COLOR = -267386864;
    public static final int ERROR_BORDER_COLOR = ColorHelper.getColor(class_1767.field_7964.method_7787()) | 0xFF000000;
    private static final int DISABLED_SLOT_COLOR = -1072689136;
    private static final int UPGRADE_TOP_HEIGHT = 7;
    private static final int UPGRADE_SLOT_HEIGHT = 16;
    private static final int UPGRADE_BOTTOM_HEIGHT = 6;
    public static final int UPGRADE_INVENTORY_OFFSET = 21;
    public static final int DISABLED_SLOT_X_POS = -2000;
    static final int SLOTS_Y_OFFSET = 17;
    static final int SLOTS_X_OFFSET = 7;
    public static final int ERROR_SLOT_COLOR = ColorHelper.getColor(class_1767.field_7964.method_7787()) | 0xAA000000;
    private static final int ERROR_TEXT_COLOR = ColorHelper.getColor(class_1767.field_7964.method_7787());
    public static final int HEIGHT_WITHOUT_STORAGE_SLOTS = 114;
    private UpgradeSettingsTabControl settingsTabControl = new UpgradeSettingsTabControl(new Position(0, 0), this, "");
    private final int numberOfUpgradeSlots;
    @Nullable
    private Button sortButton = null;
    @Nullable
    private ToggleButton<SortBy> sortByButton = null;
    private InventoryScrollPanel inventoryScrollPanel = null;
    private final Set<ToggleButton<Boolean>> upgradeSwitches = new HashSet<ToggleButton<Boolean>>();
    private final Map<Integer, UpgradeInventoryPartBase<?>> inventoryParts = new LinkedHashMap();
    private static ICraftingUIPart craftingUIPart = ICraftingUIPart.NOOP;
    private static ISlotDecorationRenderer slotDecorationRenderer = (guiGraphics, slot) -> {};
    protected StorageBackgroundProperties storageBackgroundProperties;
    @Nullable
    private Button transferToStorageButton;
    @Nullable
    private Button transferToInventoryButton;
    private TextBox searchBox;
    private Predicate<class_1799> stackFilter = stack -> this.searchBox == null || this.searchBox.getValue().isEmpty() || !stack.method_7960() && stack.method_7964().getString().toLowerCase().contains(this.searchBox.getValue().toLowerCase());
    private int visibleSlotsCount;
    private boolean initializing = true;

    public static void setCraftingUIPart(ICraftingUIPart part) {
        craftingUIPart = part;
    }

    public static void setSlotDecorationRenderer(ISlotDecorationRenderer renderer) {
        slotDecorationRenderer = renderer;
    }

    protected StorageScreenBase(S pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.numberOfUpgradeSlots = ((StorageContainerMenuBase)this.method_17577()).getNumberOfUpgradeSlots();
        this.visibleSlotsCount = ((StorageContainerMenuBase)this.method_17577()).getNumberOfStorageInventorySlots();
        this.updateDimensionsAndSlotPositions(class_310.method_1551().method_22683().method_4502());
    }

    public ICraftingUIPart getCraftingUIAddition() {
        return craftingUIPart;
    }

    public void method_25410(class_310 pMinecraft, int pWidth, int pHeight) {
        this.updateDimensionsAndSlotPositions(pHeight);
        super.method_25410(pMinecraft, pWidth, pHeight);
    }

    private void updateDimensionsAndSlotPositions(int pHeight) {
        int displayableNumberOfRows = Math.min((pHeight - 114) / 18, ((StorageContainerMenuBase)this.method_17577()).getNumberOfRows());
        int newImageHeight = 114 + this.getStorageInventoryHeight(displayableNumberOfRows);
        this.storageBackgroundProperties = ((StorageContainerMenuBase)this.method_17577()).getNumberOfStorageInventorySlots() + ((StorageContainerMenuBase)this.method_17577()).getColumnsTaken() * ((StorageContainerMenuBase)this.method_17577()).getNumberOfRows() <= 81 ? StorageBackgroundProperties.REGULAR_9_SLOT : StorageBackgroundProperties.REGULAR_12_SLOT;
        this.field_2792 = this.storageBackgroundProperties.getSlotsOnLine() * 18 + 14;
        this.updateStorageSlotsPositions();
        if (displayableNumberOfRows < ((StorageContainerMenuBase)this.method_17577()).getNumberOfRows()) {
            this.storageBackgroundProperties = this.storageBackgroundProperties == StorageBackgroundProperties.REGULAR_9_SLOT ? StorageBackgroundProperties.WIDER_9_SLOT : StorageBackgroundProperties.WIDER_12_SLOT;
            this.field_2792 += 6;
        }
        this.field_2779 = newImageHeight;
        this.field_25270 = this.field_2779 - 94;
        this.field_25269 = 8 + this.storageBackgroundProperties.getPlayerInventoryXOffset();
        this.updatePlayerSlotsPositions();
        this.updateUpgradeSlotsPositions();
        this.updateTransferButtonsPositions();
    }

    protected int getStorageInventoryHeight(int displayableNumberOfRows) {
        return displayableNumberOfRows * 18;
    }

    @Override
    public class_1735 getSlot(int slotIndex) {
        return ((StorageContainerMenuBase)this.method_17577()).method_7611(slotIndex);
    }

    protected void updateUpgradeSlotsPositions() {
        int yPosition = 6;
        for (int slotIndex = 0; slotIndex < this.numberOfUpgradeSlots; ++slotIndex) {
            class_1735 slot = ((StorageContainerMenuBase)this.method_17577()).method_7611(((StorageContainerMenuBase)this.method_17577()).getFirstUpgradeSlot() + slotIndex);
            ((SlotAccessor)slot).setY(yPosition);
            yPosition += 16;
        }
    }

    protected void updateStorageSlotsPositions() {
        int yPosition = 18;
        this.visibleSlotsCount = 0;
        for (int slotIndex = 0; slotIndex < ((StorageContainerMenuBase)this.method_17577()).getNumberOfStorageInventorySlots(); ++slotIndex) {
            class_1735 slot = ((StorageContainerMenuBase)this.method_17577()).method_7611(slotIndex);
            int lineIndex = this.visibleSlotsCount % this.getSlotsOnLine();
            if (this.stackFilter.test(slot.method_7677())) {
                ((SlotAccessor)slot).setX(8 + lineIndex * 18);
                ((SlotAccessor)slot).setY(yPosition);
                ++this.visibleSlotsCount;
                if (this.visibleSlotsCount % this.getSlotsOnLine() != 0) continue;
                yPosition += 18;
                continue;
            }
            ((SlotAccessor)slot).setX(-2000);
        }
    }

    @Override
    public Predicate<class_1799> getStackFilter() {
        return this.stackFilter;
    }

    protected void updatePlayerSlotsPositions() {
        int playerInventoryXOffset = this.storageBackgroundProperties.getPlayerInventoryXOffset();
        int yPosition = this.field_25270 + 12;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotIndex = j + i * 9;
                int xPosition = playerInventoryXOffset + 8 + j * 18;
                class_1735 slot = ((StorageContainerMenuBase)this.method_17577()).method_7611(((StorageContainerMenuBase)this.method_17577()).getInventorySlotsSize() - 36 + slotIndex);
                ((SlotAccessor)slot).setX(xPosition);
                ((SlotAccessor)slot).setY(yPosition);
            }
            yPosition += 18;
        }
        yPosition += 4;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int xPosition = playerInventoryXOffset + 8 + slotIndex * 18;
            class_1735 slot = ((StorageContainerMenuBase)this.method_17577()).method_7611(((StorageContainerMenuBase)this.method_17577()).getInventorySlotsSize() - 36 + 27 + slotIndex);
            ((SlotAccessor)slot).setX(xPosition);
            ((SlotAccessor)slot).setY(yPosition);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.updateInventoryScrollPanel();
        craftingUIPart.setStorageScreen(this);
        this.initUpgradeSettingsControl();
        this.initUpgradeInventoryParts();
        this.addUpgradeSwitches();
        ((StorageContainerMenuBase)this.method_17577()).setUpgradeChangeListener(c -> {
            this.updateStorageSlotsPositions();
            this.updatePlayerSlotsPositions();
            this.updateUpgradeSlotsPositions();
            this.updateInventoryScrollPanel();
            this.method_25396().remove(this.settingsTabControl);
            craftingUIPart.onCraftingSlotsHidden();
            this.initUpgradeSettingsControl();
            this.initUpgradeInventoryParts();
            this.addUpgradeSwitches();
        });
        if (this.shouldShowSortButtons()) {
            this.addSortButtons();
        }
        this.addTransferButtons();
        this.addSearchBox();
        this.initializing = false;
    }

    protected void addSearchBox() {
        SortButtonsPosition sortButtonsPosition = (SortButtonsPosition)((Object)Config.CLIENT.sortButtonsPosition.get());
        int x = 7;
        int xEnd = sortButtonsPosition == SortButtonsPosition.TITLE_LINE_RIGHT ? this.getSortButtonsPosition(sortButtonsPosition).x() - 1 - this.field_2776 : this.field_2792 - 7;
        int width = xEnd - x;
        this.searchBox = new SearchBox(new Position(this.field_2776 + x, this.field_2800 + 5), new Dimension(width, 10), this);
        this.searchBox.setResponder(this::onSearchPhraseChange);
        if (((StorageContainerMenuBase)this.method_17577()).shouldKeepSearchPhrase()) {
            this.searchBox.setValue(((StorageContainerMenuBase)this.method_17577()).getSearchPhrase());
        }
        this.method_37063(this.searchBox);
    }

    private void onSearchPhraseChange(String searchPhrase) {
        if (!this.initializing) {
            ((StorageContainerMenuBase)this.method_17577()).setSearchPhrase(searchPhrase);
        }
        this.updateSearchFilter(searchPhrase);
        if (this.inventoryScrollPanel != null) {
            this.inventoryScrollPanel.resetScrollDistance();
            this.inventoryScrollPanel.updateSlotsPosition();
        } else {
            this.updateStorageSlotsPositions();
        }
    }

    private void updateSearchFilter(String searchPhrase) {
        if (searchPhrase.trim().isEmpty()) {
            this.stackFilter = stack -> true;
            return;
        }
        String[] searchTerms = searchPhrase.trim().split(" ");
        ArrayList<Predicate<class_1799>> filters = new ArrayList<Predicate<class_1799>>();
        for (String searchTerm : searchTerms) {
            if (searchTerm.startsWith("@")) {
                String modName = searchTerm.substring(1).toLowerCase();
                filters.add(stack -> modName.isEmpty() || class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836().contains(modName));
                continue;
            }
            if (searchTerm.startsWith("#")) {
                String tooltipKeyword = searchTerm.substring(1).toLowerCase();
                filters.add(stack -> StorageScreenBase.method_25408((class_310)this.field_22787, (class_1799)stack).stream().anyMatch(line -> line.getString().toLowerCase().contains(tooltipKeyword)));
                continue;
            }
            filters.add(stack -> stack.method_7964().getString().toLowerCase().contains(searchTerm.toLowerCase()));
        }
        this.stackFilter = stack -> !stack.method_7960() && filters.stream().allMatch(f -> f.test(stack));
    }

    private void addTransferButtons() {
        this.transferToStorageButton = new TransferButton(filterByContents -> ((StorageContainerMenuBase)this.method_17577()).transferItemsToStorage((boolean)filterByContents), ButtonDefinitions.TRANSFER_TO_STORAGE, ButtonDefinitions.TRANSFER_TO_STORAGE_FILTERED);
        this.method_37063(this.transferToStorageButton);
        this.transferToInventoryButton = new TransferButton(filterByContents -> ((StorageContainerMenuBase)this.method_17577()).transferItemsToPlayerInventory((boolean)filterByContents), ButtonDefinitions.TRANSFER_TO_INVENTORY, ButtonDefinitions.TRANSFER_TO_INVENTORY_FILTERED);
        this.method_37063(this.transferToInventoryButton);
        this.updateTransferButtonsPositions();
    }

    protected boolean shouldShowSortButtons() {
        return true;
    }

    private void updateInventoryScrollPanel() {
        int numberOfVisibleRows;
        if (this.inventoryScrollPanel != null) {
            this.method_37066((class_364)this.inventoryScrollPanel);
        }
        if ((numberOfVisibleRows = this.getNumberOfVisibleRows()) < ((StorageContainerMenuBase)this.method_17577()).getNumberOfRows()) {
            this.inventoryScrollPanel = new InventoryScrollPanel(class_310.method_1551(), this, 0, ((StorageContainerMenuBase)this.method_17577()).getNumberOfStorageInventorySlots(), this.getSlotsOnLine(), numberOfVisibleRows * 18, ((AbstractContainerScreenAccessor)((Object)this)).getGuiTop() + 17, ((AbstractContainerScreenAccessor)((Object)this)).getGuiLeft() + 7);
            this.method_37063((class_364)this.inventoryScrollPanel);
            this.inventoryScrollPanel.updateSlotsPosition();
        } else {
            this.inventoryScrollPanel = null;
        }
    }

    private void updateTransferButtonsPositions() {
        if (this.transferToStorageButton == null || this.transferToInventoryButton == null) {
            return;
        }
        this.transferToStorageButton.setPosition(new Position(this.field_2776 + this.field_25269 + 137, this.field_2800 + this.field_25270 - 2));
        this.transferToInventoryButton.setPosition(new Position(this.field_2776 + this.field_25269 + 149, this.field_2800 + this.field_25270 - 2));
    }

    private int getNumberOfVisibleRows() {
        return Math.min((this.field_2779 - 114) / 18, ((StorageContainerMenuBase)this.method_17577()).getNumberOfRows());
    }

    public int getSlotsOnLine() {
        return this.storageBackgroundProperties.getSlotsOnLine() - ((StorageContainerMenuBase)this.method_17577()).getColumnsTaken();
    }

    private void initUpgradeInventoryParts() {
        this.inventoryParts.clear();
        if (((StorageContainerMenuBase)this.method_17577()).getColumnsTaken() == 0) {
            return;
        }
        int numberOfVisibleRows = this.getNumberOfVisibleRows();
        int scrollBarOffset = numberOfVisibleRows < ((StorageContainerMenuBase)this.method_17577()).getNumberOfRows() ? 6 : 0;
        AtomicReference<Position> pos = new AtomicReference<Position>(new Position(7 + this.getSlotsOnLine() * 18 + scrollBarOffset, 17));
        int height = numberOfVisibleRows * 18;
        for (Map.Entry<Integer, UpgradeContainerBase<?, ?>> entry : ((StorageContainerMenuBase)this.method_17577()).getUpgradeContainers().entrySet()) {
            UpgradeContainerBase<?, ?> container = entry.getValue();
            UpgradeGuiManager.getInventoryPart(entry.getKey(), container, pos.get(), height, this).ifPresent(part -> {
                this.inventoryParts.put((Integer)entry.getKey(), (UpgradeInventoryPartBase<?>)part);
                pos.set(new Position(((Position)pos.get()).x() + 36, ((Position)pos.get()).y()));
            });
        }
    }

    private void addUpgradeSwitches() {
        this.upgradeSwitches.clear();
        int switchTop = this.field_2800 + 8;
        for (int slot = 0; slot < this.numberOfUpgradeSlots; ++slot) {
            if (((StorageContainerMenuBase)this.field_2797).canDisableUpgrade(slot)) {
                int finalSlot = slot;
                ToggleButton<Boolean> upgradeSwitch = new ToggleButton<Boolean>(new Position(this.field_2776 - 22, switchTop), ButtonDefinitions.UPGRADE_SWITCH, button -> ((StorageContainerMenuBase)this.method_17577()).setUpgradeEnabled(finalSlot, !((StorageContainerMenuBase)this.method_17577()).getUpgradeEnabled(finalSlot)), () -> ((StorageContainerMenuBase)this.method_17577()).getUpgradeEnabled(finalSlot));
                this.method_25429(upgradeSwitch);
                this.upgradeSwitches.add(upgradeSwitch);
            }
            switchTop += 16;
        }
    }

    private void addSortButtons() {
        SortButtonsPosition sortButtonsPosition = (SortButtonsPosition)((Object)Config.CLIENT.sortButtonsPosition.get());
        if (sortButtonsPosition == SortButtonsPosition.HIDDEN) {
            return;
        }
        Position pos = this.getSortButtonsPosition(sortButtonsPosition);
        this.sortButton = new Button(new Position(pos.x(), pos.y()), ButtonDefinitions.SORT, button -> {
            if (button == 0) {
                ((StorageContainerMenuBase)this.method_17577()).sort();
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Sorted"), true);
            }
        });
        this.method_25429(this.sortButton);
        this.sortByButton = new ToggleButton<SortBy>(new Position(pos.x() + 12, pos.y()), ButtonDefinitions.SORT_BY, button -> {
            if (button == 0) {
                ((StorageContainerMenuBase)this.method_17577()).setSortBy(((StorageContainerMenuBase)this.method_17577()).getSortBy().next());
            }
        }, () -> ((StorageContainerMenuBase)this.method_17577()).getSortBy());
        this.method_25429(this.sortByButton);
    }

    private Position getSortButtonsPosition(SortButtonsPosition sortButtonsPosition) {
        return switch (sortButtonsPosition) {
            case SortButtonsPosition.BELOW_UPGRADES -> new Position(this.field_2776 - 21 - 2, this.field_2800 + this.getUpgradeHeightWithoutBottom() + 6 + 2);
            case SortButtonsPosition.BELOW_UPGRADE_TABS -> new Position(this.settingsTabControl.getX() + 2, this.settingsTabControl.getY() + Math.max(0, this.settingsTabControl.getHeight() + 2));
            default -> new Position(this.field_2776 + this.field_2792 - 31, this.field_2800 + 4);
        };
    }

    private void initUpgradeSettingsControl() {
        this.settingsTabControl = new UpgradeSettingsTabControl(new Position(this.field_2776 + this.field_2792, this.field_2800 + 4), this, this.getStorageSettingsTabTooltip());
        this.method_25429(this.settingsTabControl);
    }

    protected abstract String getStorageSettingsTabTooltip();

    public int getUpgradeHeight() {
        return this.getUpgradeHeightWithoutBottom() + 7;
    }

    protected int getUpgradeHeightWithoutBottom() {
        return 6 + this.numberOfUpgradeSlots * 16;
    }

    public Optional<class_768> getSortButtonsRectangle() {
        if (this.sortButton == null || this.sortByButton == null) {
            return Optional.empty();
        }
        return GuiHelper.getPositiveRectangle(this.sortButton.getX(), this.sortButton.getY(), this.sortByButton.getX() + this.sortByButton.getWidth() - this.sortButton.getX(), this.sortByButton.getY() + this.sortByButton.getHeight() - this.sortButton.getY());
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (((StorageContainerMenuBase)this.field_2797).detectSettingsChangeAndReload()) {
            this.updateStorageSlotsPositions();
            this.updatePlayerSlotsPositions();
            this.updateInventoryScrollPanel();
            this.updateTransferButtonsPositions();
        }
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, -20.0f);
        this.method_25420(guiGraphics);
        poseStack.method_22909();
        this.settingsTabControl.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.settingsTabControl.renderTooltip((class_437)this, guiGraphics, mouseX, mouseY);
        if (this.sortButton != null && this.sortByButton != null) {
            this.sortButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            this.sortByButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.upgradeSwitches.forEach(us -> us.method_25394(guiGraphics, mouseX, mouseY, partialTicks));
        this.renderErrorOverlay(guiGraphics);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2388(guiGraphics, mouseX, mouseY);
        this.renderUpgradeInventoryParts(guiGraphics, mouseX, mouseY);
        this.renderUpgradeSlots(guiGraphics, mouseX, mouseY);
        if (this.inventoryScrollPanel == null) {
            this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderUpgradeInventoryParts(class_332 guiGraphics, int mouseX, int mouseY) {
        this.inventoryParts.values().forEach(ip -> ip.render(guiGraphics, mouseX, mouseY));
    }

    private void renderStorageInventorySlots(class_332 guiGraphics, int mouseX, int mouseY) {
        this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY, true);
    }

    private void renderStorageInventorySlots(class_332 guiGraphics, int mouseX, int mouseY, boolean canShowHover) {
        for (int slotId = 0; slotId < ((StorageContainerMenuBase)this.field_2797).realInventorySlots.size() && slotId < ((StorageContainerMenuBase)this.method_17577()).getNumberOfStorageInventorySlots(); ++slotId) {
            class_1735 slot = ((StorageContainerMenuBase)this.field_2797).realInventorySlots.get(slotId);
            this.method_2385(guiGraphics, slot);
            if (!canShowHover || !((AbstractContainerScreenAccessor)((Object)this)).callIsHovering(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            this.field_2787 = slot;
            this.renderSlotOverlay(guiGraphics, slot, this.sophisticatedcore_getSlotColor(slotId));
        }
    }

    private void renderUpgradeSlots(class_332 guiGraphics, int mouseX, int mouseY) {
        for (int slotId = 0; slotId < ((StorageContainerMenuBase)this.field_2797).upgradeSlots.size(); ++slotId) {
            class_1735 slot = ((StorageContainerMenuBase)this.field_2797).upgradeSlots.get(slotId);
            if (slot.field_7873 != -2000) {
                this.method_2385(guiGraphics, slot);
                if (!slot.method_7682()) {
                    this.renderSlotOverlay(guiGraphics, slot, -1072689136);
                }
            }
            if (!((AbstractContainerScreenAccessor)((Object)this)).callIsHovering(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            this.field_2787 = slot;
            this.renderSlotOverlay(guiGraphics, slot, this.sophisticatedcore_getSlotColor(slotId));
        }
    }

    public void method_2385(class_332 guiGraphics, class_1735 slot) {
        int i = slot.field_7873;
        int j = slot.field_7872;
        class_1799 stackToRender = slot.method_7677();
        boolean flag = false;
        boolean slotsEqual = slot == ((AbstractContainerScreenAccessor)((Object)this)).getClickedSlot();
        boolean draggingItemEmpty = ((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().method_7960();
        boolean isSplittingStack = ((AbstractContainerScreenAccessor)((Object)this)).getIsSplittingStack();
        boolean rightClickDragging = slotsEqual && !draggingItemEmpty && !isSplittingStack;
        class_1799 carriedStack = ((StorageContainerMenuBase)this.method_17577()).method_34255();
        Object stackCountText = null;
        if (((StorageContainerMenuBase)this.method_17577()).isInfiniteSlot(slot.field_7874)) {
            stackCountText = "\u221e";
        }
        if (slotsEqual && !draggingItemEmpty && isSplittingStack && !stackToRender.method_7960()) {
            stackToRender = stackToRender.method_7972();
            stackToRender.method_7939(stackToRender.method_7947() / 2);
        } else if (this.field_2794 && this.field_2793.contains(slot) && !carriedStack.method_7960()) {
            if (this.field_2793.size() == 1) {
                return;
            }
            if (StorageContainerMenuBase.canItemQuickReplace(slot, carriedStack) && ((StorageContainerMenuBase)this.field_2797).method_7615(slot)) {
                int slotLimit;
                flag = true;
                int slotStackCount = stackToRender.method_7960() ? 0 : stackToRender.method_7947();
                int renderCount = StorageContainerMenuBase.getQuickCraftPlaceCount(slot, this.field_2793.size(), ((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType(), carriedStack) + slotStackCount;
                int n = slotLimit = stackToRender.method_7960() ? 64 : slot.method_7676(stackToRender);
                if (renderCount > slotLimit) {
                    stackCountText = String.valueOf(class_124.field_1054) + CountAbbreviator.abbreviate(slotLimit);
                }
                stackToRender = carriedStack.method_46651(renderCount);
            } else {
                this.field_2793.remove(slot);
                this.method_2379();
            }
        }
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 100.0f);
        if (stackToRender.method_7960() && slot.method_7682()) {
            this.renderSlotBackground(guiGraphics, slot, i, j);
        } else if (!rightClickDragging) {
            this.renderStack(guiGraphics, i, j, stackToRender, flag, (String)stackCountText);
            slotDecorationRenderer.renderDecoration(guiGraphics, slot);
        }
        poseStack.method_22909();
    }

    private void renderStack(class_332 guiGraphics, int x, int y, class_1799 itemstack, boolean flag, @Nullable String stackCountText) {
        if (flag) {
            guiGraphics.method_25294(x, y, x + 16, y + 16, -2130706433);
        }
        RenderSystem.enableDepthTest();
        guiGraphics.method_51427(itemstack, x, y);
        if (this.shouldUseSpecialCountRender(itemstack)) {
            guiGraphics.method_51432(this.field_22793, itemstack, x, y, "");
            if (stackCountText == null) {
                stackCountText = CountAbbreviator.abbreviate(itemstack.method_7947());
            }
            this.renderStackCount(guiGraphics, stackCountText, x, y);
        } else {
            guiGraphics.method_51432(this.field_22793, itemstack, x, y, stackCountText);
        }
    }

    private void renderSlotBackground(class_332 guiGraphics, class_1735 slot, int i, int j) {
        Pair pair;
        Optional<class_1799> memorizedStack = ((StorageContainerMenuBase)this.method_17577()).getMemorizedStackInSlot(slot.field_7874);
        if (((StorageContainerMenuBase)this.method_17577()).isStorageInventorySlot(slot.field_7874)) {
            if (memorizedStack.isPresent()) {
                guiGraphics.method_51427(memorizedStack.get(), i, j);
                this.drawStackOverlay(guiGraphics, i, j);
                return;
            }
            if (!((StorageContainerMenuBase)this.method_17577()).getSlotFilterItem(slot.field_7874).method_7960()) {
                guiGraphics.method_51427(((StorageContainerMenuBase)this.method_17577()).getSlotFilterItem(slot.field_7874), i, j);
                this.drawStackOverlay(guiGraphics, i, j);
                return;
            }
        }
        if ((pair = slot.method_7679()) != null) {
            class_1058 textureatlassprite = (class_1058)this.field_22787.method_1549((class_2960)pair.getFirst()).apply((class_2960)pair.getSecond());
            guiGraphics.method_25298(i, j, 0, 16, 16, textureatlassprite);
        }
    }

    private void drawStackOverlay(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_51448().method_22903();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        guiGraphics.method_25302(GuiHelper.GUI_CONTROLS, x, y, 77, 0, 16, 16);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        guiGraphics.method_51448().method_22909();
    }

    private boolean shouldUseSpecialCountRender(class_1799 itemstack) {
        return itemstack.method_7947() > 99;
    }

    private void renderSlotOverlay(class_332 guiGraphics, class_1735 slot, int slotColor) {
        this.renderSlotOverlay(guiGraphics, slot, slotColor, 0, 16);
    }

    private void renderSlotOverlay(class_332 guiGraphics, class_1735 slot, int slotColor, int yOffset, int height) {
        this.renderOverlay(guiGraphics, slotColor, slot.field_7873, slot.field_7872 + yOffset, 16, height);
    }

    public void renderOverlay(class_332 guiGraphics, int slotColor, int xPos, int yPos, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        guiGraphics.method_33284(xPos, yPos, xPos + width, yPos + height, 0, slotColor, slotColor);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.drawInventoryBg(guiGraphics, x, y, this.storageBackgroundProperties.getTextureName());
        if (this.inventoryScrollPanel == null) {
            this.drawSlotBg(guiGraphics, x, y, this.visibleSlotsCount);
            this.drawSlotOverlays(guiGraphics);
        }
        this.drawUpgradeBackground(guiGraphics);
    }

    protected void drawSlotBg(class_332 guiGraphics, int x, int y, int visibleSlotsCount) {
        int slotsOnLine = this.getSlotsOnLine();
        int slotRows = visibleSlotsCount / slotsOnLine;
        int remainingSlots = visibleSlotsCount % slotsOnLine;
        GuiHelper.renderSlotsBackground(guiGraphics, x + 7, y + 17, slotsOnLine, slotRows, remainingSlots);
    }

    private void drawSlotOverlays(class_332 guiGraphics) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)((AbstractContainerScreenAccessor)((Object)this)).getGuiLeft(), (float)((AbstractContainerScreenAccessor)((Object)this)).getGuiTop(), 0.0f);
        for (int slotNumber = 0; slotNumber < ((StorageContainerMenuBase)this.field_2797).getNumberOfStorageInventorySlots(); ++slotNumber) {
            List<Integer> colors = ((StorageContainerMenuBase)this.field_2797).getSlotOverlayColors(slotNumber);
            if (colors.isEmpty()) continue;
            int stripeHeight = 16 / colors.size();
            int i = 0;
            for (int slotColor : colors) {
                int yOffset = i * stripeHeight;
                this.renderSlotOverlay(guiGraphics, ((StorageContainerMenuBase)this.field_2797).method_7611(slotNumber), slotColor | 0x50000000, yOffset, i == colors.size() - 1 ? 16 - yOffset : stripeHeight);
                ++i;
            }
        }
        poseStack.method_22909();
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        this.inventoryParts.values().forEach(part -> part.renderTooltip(this, guiGraphics, x, y));
        if (((StorageContainerMenuBase)this.method_17577()).method_34255().method_7960() && this.field_2787 != null) {
            if (this.field_2787.method_7681()) {
                super.method_2380(guiGraphics, x, y);
            } else {
                INameableEmptySlot emptySlot;
                class_1735 class_17352 = this.field_2787;
                if (class_17352 instanceof INameableEmptySlot && (emptySlot = (INameableEmptySlot)class_17352).hasEmptyTooltip()) {
                    guiGraphics.method_51434(this.field_22793, Collections.singletonList(emptySlot.getEmptyTooltip()), x, y);
                }
            }
        }
        if (this.sortButton != null) {
            this.sortButton.renderTooltip((class_437)this, guiGraphics, x, y);
        }
        if (this.sortByButton != null) {
            this.sortByButton.renderTooltip((class_437)this, guiGraphics, x, y);
        }
        if (this.transferToStorageButton != null) {
            this.transferToStorageButton.renderTooltip((class_437)this, guiGraphics, x, y);
        }
        if (this.transferToInventoryButton != null) {
            this.transferToInventoryButton.renderTooltip((class_437)this, guiGraphics, x, y);
        }
        if (this.searchBox != null) {
            this.searchBox.renderTooltip((class_437)this, guiGraphics, x, y);
        }
    }

    protected List<class_2561> method_51454(class_1799 itemStack) {
        List ret = StorageScreenBase.method_25408((class_310)this.field_22787, (class_1799)itemStack);
        if (this.field_2787 != null && this.field_2787 instanceof StorageInventorySlot && this.field_2787.method_7675() != itemStack.method_7914()) {
            ret.add(class_2561.method_43469((String)TranslationHelper.INSTANCE.translGuiTooltip("stack_count"), (Object[])new Object[]{class_2561.method_43470((String)NumberFormat.getNumberInstance().format(itemStack.method_7947())).method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)" / ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)NumberFormat.getNumberInstance().format(this.field_2787.method_7676(itemStack))).method_27692(class_124.field_1062))}).method_27692(class_124.field_1080));
        }
        return ret;
    }

    public void drawInventoryBg(class_332 guiGraphics, int x, int y, class_2960 textureName) {
        StorageGuiHelper.renderStorageBackground(new Position(x, y), guiGraphics, textureName, this.field_2792, this.field_2779 - 114);
    }

    private void drawUpgradeBackground(class_332 guiGraphics) {
        if (this.numberOfUpgradeSlots == 0) {
            return;
        }
        int heightWithoutBottom = this.getUpgradeHeightWithoutBottom();
        guiGraphics.method_25290(GuiHelper.GUI_CONTROLS, this.field_2776 - 21, this.field_2800, 0.0f, 0.0f, 26, 4, 256, 256);
        guiGraphics.method_25290(GuiHelper.GUI_CONTROLS, this.field_2776 - 21, this.field_2800 + 4, 0.0f, 4.0f, 25, heightWithoutBottom - 4, 256, 256);
        guiGraphics.method_25290(GuiHelper.GUI_CONTROLS, this.field_2776 - 21, this.field_2800 + heightWithoutBottom, 0.0f, 198.0f, 25, 6, 256, 256);
        boolean previousHasSwitch = false;
        for (int slot = 0; slot < this.numberOfUpgradeSlots; ++slot) {
            if (((StorageContainerMenuBase)this.field_2797).canDisableUpgrade(slot)) {
                int y = this.field_2800 + 5 + slot * 16 + (previousHasSwitch ? 1 : 0);
                guiGraphics.method_25290(GuiHelper.GUI_CONTROLS, this.field_2776 - 21 - 4, y, 0.0f, (float)(204 + (previousHasSwitch ? 1 : 0)), 7, 18 - (previousHasSwitch ? 1 : 0), 256, 256);
                previousHasSwitch = true;
                continue;
            }
            previousHasSwitch = false;
        }
    }

    public UpgradeSettingsTabControl getUpgradeSettingsControl() {
        return this.settingsTabControl;
    }

    @Nullable
    public class_1735 method_2386(double mouseX, double mouseY) {
        class_1735 slot;
        int i;
        for (i = 0; i < ((StorageContainerMenuBase)this.field_2797).upgradeSlots.size(); ++i) {
            slot = ((StorageContainerMenuBase)this.field_2797).upgradeSlots.get(i);
            if (!((AbstractContainerScreenAccessor)((Object)this)).callIsHovering(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            return slot;
        }
        if (this.inventoryScrollPanel != null) {
            Optional<class_1735> result = this.inventoryScrollPanel.findSlot(mouseX, mouseY);
            if (result.isPresent()) {
                return result.get();
            }
            slot = super.method_2386(mouseX, mouseY);
            return slot == null || ((StorageContainerMenuBase)this.field_2797).isStorageInventorySlot(slot.field_7874) ? null : slot;
        }
        for (i = 0; i < ((StorageContainerMenuBase)this.field_2797).realInventorySlots.size(); ++i) {
            slot = ((StorageContainerMenuBase)this.field_2797).realInventorySlots.get(i);
            if (!((AbstractContainerScreenAccessor)((Object)this)).callIsHovering(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            return slot;
        }
        return super.method_2386(mouseX, mouseY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        for (UpgradeInventoryPartBase<?> inventoryPart : this.inventoryParts.values()) {
            if (!inventoryPart.handleMouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        this.handleQuickMoveAll(mouseX, mouseY, button);
        return super.method_25406(mouseX, mouseY, button);
    }

    private void handleQuickMoveAll(double mouseX, double mouseY, int button) {
        class_1735 slot = this.method_2386(mouseX, mouseY);
        if (((AbstractContainerScreenAccessor)((Object)this)).getDoubleclick() && !((StorageContainerMenuBase)this.method_17577()).method_34255().method_7960() && slot != null && button == 0 && ((StorageContainerMenuBase)this.field_2797).method_7613(class_1799.field_8037, slot) && StorageScreenBase.method_25442() && !((AbstractContainerScreenAccessor)((Object)this)).getLastQuickMoved().method_7960()) {
            for (class_1735 slot2 : ((StorageContainerMenuBase)this.field_2797).realInventorySlots) {
                this.tryQuickMoveSlot(button, slot, slot2);
            }
        }
    }

    private void tryQuickMoveSlot(int button, class_1735 slot, class_1735 slot2) {
        if (slot2.method_7674((class_1657)this.field_22787.field_1724) && slot2.method_7681() && slot2.isSameInventory(slot)) {
            class_1799 slotItem = slot2.method_7677();
            if (class_1799.method_31577((class_1799)((AbstractContainerScreenAccessor)((Object)this)).getLastQuickMoved(), (class_1799)slotItem)) {
                if (slotItem.method_7947() > slotItem.method_7914()) {
                    PacketHandler.sendToServer(new TransferFullSlotMessage(slot2.field_7874));
                } else {
                    this.method_2383(slot2, slot2.field_7874, button, class_1713.field_7794);
                }
            }
        }
    }

    protected void method_2383(class_1735 slot, int slotNumber, int mouseButton, class_1713 type) {
        if (type == class_1713.field_7793 && !((StorageContainerMenuBase)this.field_2797).getSlotUpgradeContainer(slot).map(c -> c.allowsPickupAll(slot)).orElse(true).booleanValue()) {
            type = class_1713.field_7790;
        }
        this.handleInventoryMouseClick(slotNumber, mouseButton, type);
    }

    private void handleInventoryMouseClick(int slotNumber, int mouseButton, class_1713 type) {
        class_1799 itemstack;
        int lastChecked;
        class_1799 slotStack;
        class_1799 itemstack2;
        int i;
        StorageContainerMenuBase menu = (StorageContainerMenuBase)this.method_17577();
        ArrayList realInventoryItems = new ArrayList(menu.realInventorySlots.size());
        menu.realInventorySlots.forEach(slot -> realInventoryItems.add(slot.method_7677().method_7972()));
        ArrayList upgradeItems = new ArrayList(menu.upgradeSlots.size());
        menu.upgradeSlots.forEach(slot -> upgradeItems.add(slot.method_7677().method_7972()));
        menu.method_7593(slotNumber, mouseButton, type, (class_1657)this.field_22787.field_1724);
        Int2ObjectOpenHashMap changedSlotIndexes = new Int2ObjectOpenHashMap();
        int inventorySlotsToCheck = Math.min(realInventoryItems.size() - 36, menu.getInventorySlotsSize() - 36);
        for (i = 0; i < inventorySlotsToCheck; ++i) {
            class_1799 slotStack2;
            itemstack2 = (class_1799)realInventoryItems.get(i);
            if (class_1799.method_7973((class_1799)itemstack2, (class_1799)(slotStack2 = menu.method_7611(i).method_7677()))) continue;
            changedSlotIndexes.put(i, (Object)slotStack2.method_7972());
        }
        for (i = 0; i < 36; ++i) {
            int slotIndex;
            itemstack2 = (class_1799)realInventoryItems.get(realInventoryItems.size() - 36 + i);
            if (class_1799.method_7973((class_1799)itemstack2, (class_1799)(slotStack = menu.method_7611(slotIndex = menu.getInventorySlotsSize() - 36 + i).method_7677()))) continue;
            changedSlotIndexes.put(slotIndex, (Object)slotStack.method_7972());
        }
        int upgradeSlotsToCheck = Math.min(menu.getUpgradeSlotsSize(), upgradeItems.size());
        for (lastChecked = 0; lastChecked < upgradeSlotsToCheck && class_1799.method_7973((class_1799)(itemstack = (class_1799)upgradeItems.get(lastChecked)), (class_1799)(slotStack = menu.method_7611(menu.getInventorySlotsSize() + lastChecked).method_7677())); ++lastChecked) {
        }
        for (int i2 = upgradeSlotsToCheck - 1; i2 >= lastChecked; --i2) {
            int slotIndex;
            class_1799 slotStack3;
            class_1799 itemstack3 = (class_1799)upgradeItems.get(i2);
            if (class_1799.method_7973((class_1799)itemstack3, (class_1799)(slotStack3 = menu.method_7611(slotIndex = menu.getInventorySlotsSize() + i2).method_7677()))) continue;
            changedSlotIndexes.put(slotIndex, (Object)slotStack3.method_7972());
        }
        this.field_22787.field_1724.field_3944.method_2883((class_2596)new class_2813(menu.field_7763, menu.method_37421(), slotNumber, mouseButton, type, menu.method_34255().method_7972(), (Int2ObjectMap)changedSlotIndexes));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_1735 slot = this.method_2386(mouseX, mouseY);
        if (StorageScreenBase.method_25442() && StorageScreenBase.method_25441() && slot instanceof StorageInventorySlot && button == 0) {
            PacketHandler.sendToServer(new TransferFullSlotMessage(slot.field_7874));
            return true;
        }
        class_364 focused = this.method_25399();
        if (focused != null && !focused.method_25405(mouseX, mouseY) && focused instanceof WidgetBase) {
            WidgetBase widgetBase = (WidgetBase)focused;
            widgetBase.method_25365(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (class_364 child : this.method_25396()) {
            if (!child.method_25405(mouseX, mouseY) || !child.method_25403(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        class_1735 slot = this.method_2386(mouseX, mouseY);
        class_1799 itemstack = ((StorageContainerMenuBase)this.method_17577()).method_34255();
        if (this.field_2794) {
            if (slot != null && !itemstack.method_7960() && (itemstack.method_7947() > this.field_2793.size() || ((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType() == 2) && StorageContainerMenuBase.canItemQuickReplace(slot, itemstack) && slot.method_7680(itemstack) && ((StorageContainerMenuBase)this.field_2797).method_7615(slot) && this.isAllowedSlotCombination(slot, itemstack)) {
                this.field_2793.add(slot);
                this.method_2379();
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    private boolean isAllowedSlotCombination(class_1735 slot, class_1799 carried) {
        UpgradeItemBase upgradeItem;
        class_1792 class_17922;
        if (this.field_2793.isEmpty() || !((class_17922 = carried.method_7909()) instanceof UpgradeItemBase) || (upgradeItem = (UpgradeItemBase)class_17922).getInventoryColumnsTaken() == 0) {
            return true;
        }
        return this.field_2793.contains(slot) || !(this.field_2793.iterator().next() instanceof StorageContainerMenuBase.StorageUpgradeSlot) && !(slot instanceof StorageContainerMenuBase.StorageUpgradeSlot);
    }

    protected boolean method_2381(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.method_2381(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.hasClickedOutsideOfUpgradeSlots(mouseX, mouseY) && this.hasClickedOutsideOfUpgradeSettings(mouseX, mouseY);
    }

    private boolean hasClickedOutsideOfUpgradeSettings(double mouseX, double mouseY) {
        return this.settingsTabControl.getTabRectangles().stream().noneMatch(r -> r.method_3318((int)mouseX, (int)mouseY));
    }

    private boolean hasClickedOutsideOfUpgradeSlots(double mouseX, double mouseY) {
        return this.getUpgradeSlotsRectangle().map(r -> r.method_3318((int)mouseX, (int)mouseY)).orElse(false) == false;
    }

    public Optional<class_768> getUpgradeSlotsRectangle() {
        return this.numberOfUpgradeSlots == 0 ? Optional.empty() : GuiHelper.getPositiveRectangle(this.field_2776 - 21 - (!this.upgradeSwitches.isEmpty() ? 4 : 0), this.field_2800, 21 + (!this.upgradeSwitches.isEmpty() ? 4 : 0), this.getUpgradeHeight());
    }

    private void renderStackCount(class_332 guiGraphics, String count, int x, int y) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 200.0);
        float scale = Math.min(1.0f, 16.0f / (float)this.field_22793.method_1727(count));
        if (scale < 1.0f) {
            poseStack.method_22905(scale, scale, 1.0f);
        }
        class_4597.class_4598 renderBuffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        this.field_22793.method_27521(count, ((float)(x + 19 - 2) - (float)this.field_22793.method_1727(count) * scale) / scale, ((float)(y + 6 + 3) + (1.0f / (scale * scale) - 1.0f)) / scale, 0xFFFFFF, true, poseStack.method_23760().method_23761(), (class_4597)renderBuffer, class_327.class_6415.field_33993, 0, 0xF000F0);
        renderBuffer.method_22993();
        poseStack.method_22909();
    }

    protected void method_2379() {
        class_1799 carriedStack = ((StorageContainerMenuBase)this.method_17577()).method_34255();
        if (!carriedStack.method_7960() && this.field_2794) {
            if (((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType() == 2) {
                ((AbstractContainerScreenAccessor)((Object)this)).setQuickCraftingRemainder(carriedStack.method_7914());
            } else {
                ((AbstractContainerScreenAccessor)((Object)this)).setQuickCraftingRemainder(carriedStack.method_7947());
                for (class_1735 slot : this.field_2793) {
                    class_1799 slotStack = slot.method_7677();
                    int slotStackCount = slotStack.method_7960() ? 0 : slotStack.method_7947();
                    int maxStackSize = slot.method_7676(carriedStack);
                    int quickCraftPlaceCount = Math.min(StorageContainerMenuBase.getQuickCraftPlaceCount(slot, this.field_2793.size(), ((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType(), carriedStack) + slotStackCount, maxStackSize);
                    ((AbstractContainerScreenAccessor)((Object)this)).setQuickCraftingRemainder(((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingRemainder() - quickCraftPlaceCount - slotStackCount);
                }
            }
        }
    }

    private void renderErrorOverlay(class_332 guiGraphics) {
        ((StorageContainerMenuBase)this.field_2797).getErrorUpgradeSlotChangeResult().ifPresent(upgradeSlotChangeResult -> upgradeSlotChangeResult.getErrorMessage().ifPresent(overlayErrorMessage -> {
            RenderSystem.disableDepthTest();
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416((float)((AbstractContainerScreenAccessor)((Object)this)).getGuiLeft(), (float)((AbstractContainerScreenAccessor)((Object)this)).getGuiTop(), 0.0f);
            upgradeSlotChangeResult.getErrorUpgradeSlots().forEach(slotIndex -> {
                class_1735 upgradeSlot = ((StorageContainerMenuBase)this.field_2797).method_7611(((StorageContainerMenuBase)this.field_2797).getFirstUpgradeSlot() + slotIndex);
                this.renderSlotOverlay(guiGraphics, upgradeSlot, ERROR_SLOT_COLOR);
            });
            upgradeSlotChangeResult.getErrorInventorySlots().forEach(slotIndex -> {
                class_1735 slot = ((StorageContainerMenuBase)this.field_2797).method_7611((int)slotIndex);
                if (slot != null) {
                    this.renderSlotOverlay(guiGraphics, slot, ERROR_SLOT_COLOR);
                }
            });
            upgradeSlotChangeResult.getErrorInventoryParts().forEach(partIndex -> {
                UpgradeInventoryPartBase<?> inventoryPart;
                if (this.inventoryParts.size() > partIndex && (inventoryPart = this.inventoryParts.get(partIndex)) != null) {
                    inventoryPart.renderErrorOverlay(guiGraphics);
                }
            });
            poseStack.method_22909();
            this.renderErrorMessage(poseStack, (class_2561)overlayErrorMessage);
        }));
    }

    private void renderErrorMessage(class_4587 matrixStack, class_2561 overlayErrorMessage) {
        matrixStack.method_22903();
        matrixStack.method_22904((double)((float)this.field_22789 / 2.0f), (double)this.field_2800 + (double)this.field_25270 + 4.0, 300.0);
        class_327 fontrenderer = class_310.method_1551().field_1772;
        int tooltipWidth = this.field_22793.method_27525((class_5348)overlayErrorMessage);
        ArrayList<Object> wrappedTextLines = new ArrayList<Object>();
        int maxLineWidth = 260;
        if (tooltipWidth > maxLineWidth) {
            int wrappedTooltipWidth = 0;
            List wrappedLine = this.field_22793.method_27527().method_27495((class_5348)overlayErrorMessage, maxLineWidth, class_2583.field_24360);
            for (class_5348 line : wrappedLine) {
                int lineWidth = this.field_22793.method_27525(line);
                if (lineWidth > wrappedTooltipWidth) {
                    wrappedTooltipWidth = lineWidth;
                }
                wrappedTextLines.add(line);
            }
            tooltipWidth = wrappedTooltipWidth;
        } else {
            wrappedTextLines.add(overlayErrorMessage);
        }
        int tooltipHeight = 8;
        if (wrappedTextLines.size() > 1) {
            tooltipHeight += 2 + (wrappedTextLines.size() - 1) * 10;
        }
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        float leftX = (float)(-tooltipWidth) / 2.0f;
        GuiHelper.renderTooltipBackground(matrix4f, tooltipWidth, (int)leftX, 0, tooltipHeight, -267386864, ERROR_BORDER_COLOR, ERROR_BORDER_COLOR);
        class_4597.class_4598 renderTypeBuffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        matrixStack.method_22904(0.0, 0.0, 400.0);
        GuiHelper.writeTooltipLines(wrappedTextLines, fontrenderer, leftX, 0, matrix4f, renderTypeBuffer, ERROR_TEXT_COLOR);
        renderTypeBuffer.method_22993();
        matrixStack.method_22909();
    }

    @Override
    public void renderInventorySlots(class_332 guiGraphics, int mouseX, int mouseY, boolean canShowHover) {
        this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY, canShowHover);
    }

    @Override
    public boolean isMouseOverSlot(class_1735 pSlot, double pMouseX, double pMouseY) {
        return ((AbstractContainerScreenAccessor)((Object)this)).callIsHovering(pSlot, pMouseX, pMouseY);
    }

    public boolean method_2387(class_1735 slot, double mouseX, double mouseY) {
        return super.method_2387(slot, mouseX, mouseY) && this.getUpgradeSettingsControl().slotIsNotCoveredAt(slot, mouseX, mouseY);
    }

    @Override
    public int getTopY() {
        return ((AbstractContainerScreenAccessor)((Object)this)).getGuiTop();
    }

    @Override
    public void drawSlotBg(class_332 guiGraphics, int visibleSlotsCount) {
        this.drawSlotBg(guiGraphics, (this.field_22789 - this.field_2792) / 2, (this.field_22790 - this.field_2779) / 2, visibleSlotsCount);
        this.drawSlotOverlays(guiGraphics);
    }

    @Override
    public int getLeftX() {
        return ((AbstractContainerScreenAccessor)((Object)this)).getGuiLeft();
    }

    protected void method_37432() {
        super.method_37432();
        this.settingsTabControl.tick();
    }

    private class TransferButton
    extends Button {
        private final ButtonDefinition shiftDefinition;
        private final ButtonDefinition definition;

        public TransferButton(Consumer<Boolean> transferItems, ButtonDefinition shiftDefinition, ButtonDefinition definition) {
            super(new Position(StorageScreenBase.this.field_2776, StorageScreenBase.this.field_2800), definition, (int button) -> {
                if (button == 0) {
                    transferItems.accept(!class_437.method_25442());
                }
            });
            this.shiftDefinition = shiftDefinition;
            this.definition = definition;
        }

        @Override
        protected void renderWidget(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (class_437.method_25442()) {
                GuiHelper.blit(guiGraphics, this.x, this.y, this.shiftDefinition.getForegroundTexture());
            } else {
                GuiHelper.blit(guiGraphics, this.x, this.y, this.definition.getForegroundTexture());
            }
        }

        @Override
        protected List<class_2561> getTooltip() {
            if (class_437.method_25442()) {
                return this.shiftDefinition.getTooltip();
            }
            return this.definition.getTooltip();
        }
    }
}

